-- ==============================================================
-- File generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
-- Version: 2016.4
-- Copyright (C) 1986-2017 Xilinx, Inc. All Rights Reserved.
-- 
-- ==============================================================

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_arith.all;
use IEEE.numeric_std.all;
use ieee.std_logic_textio.all;
use std.textio.all;


entity apatb_infer_only_top is
  generic (
       AUTOTB_CLOCK_PERIOD_DIV2 :   TIME := 5.00 ns;
       AUTOTB_TVIN_C1_weight : STRING := "./c.infer_only.autotvin_C1_weight.dat";
       AUTOTB_TVIN_C1_bias : STRING := "./c.infer_only.autotvin_C1_bias.dat";
       AUTOTB_TVIN_C2_weight : STRING := "./c.infer_only.autotvin_C2_weight.dat";
       AUTOTB_TVIN_C2_bias : STRING := "./c.infer_only.autotvin_C2_bias.dat";
       AUTOTB_TVIN_C3_weight : STRING := "./c.infer_only.autotvin_C3_weight.dat";
       AUTOTB_TVIN_C3_bias : STRING := "./c.infer_only.autotvin_C3_bias.dat";
       AUTOTB_TVIN_F1_weight : STRING := "./c.infer_only.autotvin_F1_weight.dat";
       AUTOTB_TVIN_F1_bias : STRING := "./c.infer_only.autotvin_F1_bias.dat";
       AUTOTB_TVIN_F2_weight : STRING := "./c.infer_only.autotvin_F2_weight.dat";
       AUTOTB_TVIN_F2_bias : STRING := "./c.infer_only.autotvin_F2_bias.dat";
       AUTOTB_TVIN_Input_Test_Img : STRING := "./c.infer_only.autotvin_Input_Test_Img.dat";
       AUTOTB_TVIN_Test_Label : STRING := "./c.infer_only.autotvin_Test_Label.dat";
       AUTOTB_TVIN_C1_weight_out_wrapc : STRING := "./rtl.infer_only.autotvin_C1_weight.dat";
       AUTOTB_TVIN_C1_bias_out_wrapc : STRING := "./rtl.infer_only.autotvin_C1_bias.dat";
       AUTOTB_TVIN_C2_weight_out_wrapc : STRING := "./rtl.infer_only.autotvin_C2_weight.dat";
       AUTOTB_TVIN_C2_bias_out_wrapc : STRING := "./rtl.infer_only.autotvin_C2_bias.dat";
       AUTOTB_TVIN_C3_weight_out_wrapc : STRING := "./rtl.infer_only.autotvin_C3_weight.dat";
       AUTOTB_TVIN_C3_bias_out_wrapc : STRING := "./rtl.infer_only.autotvin_C3_bias.dat";
       AUTOTB_TVIN_F1_weight_out_wrapc : STRING := "./rtl.infer_only.autotvin_F1_weight.dat";
       AUTOTB_TVIN_F1_bias_out_wrapc : STRING := "./rtl.infer_only.autotvin_F1_bias.dat";
       AUTOTB_TVIN_F2_weight_out_wrapc : STRING := "./rtl.infer_only.autotvin_F2_weight.dat";
       AUTOTB_TVIN_F2_bias_out_wrapc : STRING := "./rtl.infer_only.autotvin_F2_bias.dat";
       AUTOTB_TVIN_Input_Test_Img_out_wrapc : STRING := "./rtl.infer_only.autotvin_Input_Test_Img.dat";
       AUTOTB_TVIN_Test_Label_out_wrapc : STRING := "./rtl.infer_only.autotvin_Test_Label.dat";
       AUTOTB_TVOUT_judge : STRING := "./c.infer_only.autotvout_judge.dat";
       AUTOTB_TVOUT_judge_out_wrapc : STRING := "./impl_rtl.infer_only.autotvout_judge.dat";
      AUTOTB_LAT_RESULT_FILE    : STRING  := "infer_only.result.lat.rb";
      AUTOTB_PER_RESULT_TRANS_FILE    : STRING  := "infer_only.performance.result.transaction.xml";
      LENGTH_C1_weight     : INTEGER := 150;
      LENGTH_C1_bias     : INTEGER := 6;
      LENGTH_C2_weight     : INTEGER := 2400;
      LENGTH_C2_bias     : INTEGER := 16;
      LENGTH_C3_weight     : INTEGER := 30720;
      LENGTH_C3_bias     : INTEGER := 120;
      LENGTH_F1_weight     : INTEGER := 10080;
      LENGTH_F1_bias     : INTEGER := 84;
      LENGTH_F2_weight     : INTEGER := 840;
      LENGTH_F2_bias     : INTEGER := 10;
      LENGTH_Input_Test_Img     : INTEGER := 7840000;
      LENGTH_Test_Label     : INTEGER := 100000;
      LENGTH_judge     : INTEGER := 1;
	    AUTOTB_TRANSACTION_NUM    : INTEGER := 1
);

end apatb_infer_only_top;

architecture behav of apatb_infer_only_top is 
  signal AESL_clock	:   STD_LOGIC := '0';
  signal rst  :   STD_LOGIC;
  signal start    :   STD_LOGIC := '0';
  signal ce       :   STD_LOGIC;
  signal continue :   STD_LOGIC := '0';
  signal AESL_reset :   STD_LOGIC := '0';
  signal AESL_start :   STD_LOGIC := '0';
  signal AESL_ce :   STD_LOGIC := '0';
  signal AESL_continue :   STD_LOGIC := '0';
  signal AESL_ready :   STD_LOGIC := '0';
  signal AESL_idle :   STD_LOGIC := '0';
  signal AESL_done :   STD_LOGIC := '0';
  signal AESL_done_delay :   STD_LOGIC := '0';
  signal AESL_done_delay2 :   STD_LOGIC := '0';
  signal AESL_ready_delay :   STD_LOGIC := '0';
  signal ready :   STD_LOGIC := '0';
  signal ready_wire :   STD_LOGIC := '0';

  signal ap_clk :  STD_LOGIC;
  signal ap_rst :  STD_LOGIC;
  signal ap_start :  STD_LOGIC;
  signal ap_done :  STD_LOGIC;
  signal ap_idle :  STD_LOGIC;
  signal ap_ready :  STD_LOGIC;
  signal C1_weight_address0 :  STD_LOGIC_VECTOR (7 DOWNTO 0);
  signal C1_weight_ce0 :  STD_LOGIC;
  signal C1_weight_q0 :  STD_LOGIC_VECTOR (31 DOWNTO 0);
  signal C1_bias_address0 :  STD_LOGIC_VECTOR (2 DOWNTO 0);
  signal C1_bias_ce0 :  STD_LOGIC;
  signal C1_bias_q0 :  STD_LOGIC_VECTOR (31 DOWNTO 0);
  signal C2_weight_address0 :  STD_LOGIC_VECTOR (11 DOWNTO 0);
  signal C2_weight_ce0 :  STD_LOGIC;
  signal C2_weight_q0 :  STD_LOGIC_VECTOR (31 DOWNTO 0);
  signal C2_bias_address0 :  STD_LOGIC_VECTOR (3 DOWNTO 0);
  signal C2_bias_ce0 :  STD_LOGIC;
  signal C2_bias_q0 :  STD_LOGIC_VECTOR (31 DOWNTO 0);
  signal C3_weight_address0 :  STD_LOGIC_VECTOR (14 DOWNTO 0);
  signal C3_weight_ce0 :  STD_LOGIC;
  signal C3_weight_q0 :  STD_LOGIC_VECTOR (31 DOWNTO 0);
  signal C3_bias_address0 :  STD_LOGIC_VECTOR (6 DOWNTO 0);
  signal C3_bias_ce0 :  STD_LOGIC;
  signal C3_bias_q0 :  STD_LOGIC_VECTOR (31 DOWNTO 0);
  signal F1_weight_address0 :  STD_LOGIC_VECTOR (13 DOWNTO 0);
  signal F1_weight_ce0 :  STD_LOGIC;
  signal F1_weight_q0 :  STD_LOGIC_VECTOR (31 DOWNTO 0);
  signal F1_bias_address0 :  STD_LOGIC_VECTOR (6 DOWNTO 0);
  signal F1_bias_ce0 :  STD_LOGIC;
  signal F1_bias_q0 :  STD_LOGIC_VECTOR (31 DOWNTO 0);
  signal F2_weight_address0 :  STD_LOGIC_VECTOR (9 DOWNTO 0);
  signal F2_weight_ce0 :  STD_LOGIC;
  signal F2_weight_q0 :  STD_LOGIC_VECTOR (31 DOWNTO 0);
  signal F2_bias_address0 :  STD_LOGIC_VECTOR (3 DOWNTO 0);
  signal F2_bias_ce0 :  STD_LOGIC;
  signal F2_bias_q0 :  STD_LOGIC_VECTOR (31 DOWNTO 0);
  signal Input_Test_Img_address0 :  STD_LOGIC_VECTOR (22 DOWNTO 0);
  signal Input_Test_Img_ce0 :  STD_LOGIC;
  signal Input_Test_Img_q0 :  STD_LOGIC_VECTOR (31 DOWNTO 0);
  signal Test_Label_address0 :  STD_LOGIC_VECTOR (16 DOWNTO 0);
  signal Test_Label_ce0 :  STD_LOGIC;
  signal Test_Label_q0 :  STD_LOGIC_VECTOR (31 DOWNTO 0);
  signal judge :  STD_LOGIC;
  signal judge_ap_vld :  STD_LOGIC;

  signal ready_cnt : STD_LOGIC_VECTOR(31 DOWNTO 0);
  signal done_cnt	: STD_LOGIC_VECTOR(31 DOWNTO 0);
  signal ready_initial  :	STD_LOGIC;
  signal ready_initial_n	:   STD_LOGIC;
  signal ready_last_n   :	STD_LOGIC;
  signal ready_delay_last_n	:   STD_LOGIC;
  signal done_delay_last_n	:   STD_LOGIC;
  signal interface_done :	STD_LOGIC := '0';
  -- Subtype for random state number, to prevent confusing it with true integers
  -- Top of range should be (2**31)-1 but this literal calculation causes overflow on 32-bit machines
  subtype T_RANDINT is integer range 1 to integer'high;

  type latency_record is array(0 to AUTOTB_TRANSACTION_NUM + 1) of INTEGER;
  shared variable AESL_mLatCnterIn : latency_record;
  shared variable AESL_mLatCnterOut : latency_record;
  shared variable AESL_mLatCnterIn_addr : INTEGER;
  shared variable AESL_mLatCnterOut_addr : INTEGER;
  shared variable AESL_clk_counter : INTEGER;
  signal reported_stuck : STD_LOGIC   := '0';
  shared variable reported_stuck_cnt : INTEGER := 0;
component infer_only is
port (
    ap_clk :  IN STD_LOGIC;
    ap_rst :  IN STD_LOGIC;
    ap_start :  IN STD_LOGIC;
    ap_done :  OUT STD_LOGIC;
    ap_idle :  OUT STD_LOGIC;
    ap_ready :  OUT STD_LOGIC;
    C1_weight_address0 :  OUT STD_LOGIC_VECTOR (7 DOWNTO 0);
    C1_weight_ce0 :  OUT STD_LOGIC;
    C1_weight_q0 :  IN STD_LOGIC_VECTOR (31 DOWNTO 0);
    C1_bias_address0 :  OUT STD_LOGIC_VECTOR (2 DOWNTO 0);
    C1_bias_ce0 :  OUT STD_LOGIC;
    C1_bias_q0 :  IN STD_LOGIC_VECTOR (31 DOWNTO 0);
    C2_weight_address0 :  OUT STD_LOGIC_VECTOR (11 DOWNTO 0);
    C2_weight_ce0 :  OUT STD_LOGIC;
    C2_weight_q0 :  IN STD_LOGIC_VECTOR (31 DOWNTO 0);
    C2_bias_address0 :  OUT STD_LOGIC_VECTOR (3 DOWNTO 0);
    C2_bias_ce0 :  OUT STD_LOGIC;
    C2_bias_q0 :  IN STD_LOGIC_VECTOR (31 DOWNTO 0);
    C3_weight_address0 :  OUT STD_LOGIC_VECTOR (14 DOWNTO 0);
    C3_weight_ce0 :  OUT STD_LOGIC;
    C3_weight_q0 :  IN STD_LOGIC_VECTOR (31 DOWNTO 0);
    C3_bias_address0 :  OUT STD_LOGIC_VECTOR (6 DOWNTO 0);
    C3_bias_ce0 :  OUT STD_LOGIC;
    C3_bias_q0 :  IN STD_LOGIC_VECTOR (31 DOWNTO 0);
    F1_weight_address0 :  OUT STD_LOGIC_VECTOR (13 DOWNTO 0);
    F1_weight_ce0 :  OUT STD_LOGIC;
    F1_weight_q0 :  IN STD_LOGIC_VECTOR (31 DOWNTO 0);
    F1_bias_address0 :  OUT STD_LOGIC_VECTOR (6 DOWNTO 0);
    F1_bias_ce0 :  OUT STD_LOGIC;
    F1_bias_q0 :  IN STD_LOGIC_VECTOR (31 DOWNTO 0);
    F2_weight_address0 :  OUT STD_LOGIC_VECTOR (9 DOWNTO 0);
    F2_weight_ce0 :  OUT STD_LOGIC;
    F2_weight_q0 :  IN STD_LOGIC_VECTOR (31 DOWNTO 0);
    F2_bias_address0 :  OUT STD_LOGIC_VECTOR (3 DOWNTO 0);
    F2_bias_ce0 :  OUT STD_LOGIC;
    F2_bias_q0 :  IN STD_LOGIC_VECTOR (31 DOWNTO 0);
    Input_Test_Img_address0 :  OUT STD_LOGIC_VECTOR (22 DOWNTO 0);
    Input_Test_Img_ce0 :  OUT STD_LOGIC;
    Input_Test_Img_q0 :  IN STD_LOGIC_VECTOR (31 DOWNTO 0);
    Test_Label_address0 :  OUT STD_LOGIC_VECTOR (16 DOWNTO 0);
    Test_Label_ce0 :  OUT STD_LOGIC;
    Test_Label_q0 :  IN STD_LOGIC_VECTOR (31 DOWNTO 0);
    judge :  OUT STD_LOGIC;
    judge_ap_vld :  OUT STD_LOGIC);
end component;

signal arrayC1_weight_ce0, arrayC1_weight_ce1 : STD_LOGIC;
signal arrayC1_weight_we0, arrayC1_weight_we1 : STD_LOGIC;
signal arrayC1_weight_address0, arrayC1_weight_address1 : STD_LOGIC_VECTOR(7 downto 0);
signal arrayC1_weight_din0, arrayC1_weight_din1 : STD_LOGIC_VECTOR(31 downto 0);
signal arrayC1_weight_dout0, arrayC1_weight_dout1 :  STD_LOGIC_VECTOR(31 downto 0);
signal arrayC1_weight_ready : STD_LOGIC;
signal arrayC1_weight_done : STD_LOGIC;

component AESL_automem_C1_weight is
  port(
    clk        :  IN  STD_LOGIC;
    rst        :  IN  STD_LOGIC;
    ce0        :  IN  STD_LOGIC;
    we0        :  IN  STD_LOGIC;
    address0   :  IN  STD_LOGIC_VECTOR;
    din0       :  IN  STD_LOGIC_VECTOR;
    dout0      :  OUT STD_LOGIC_VECTOR;
    ce1        :  IN  STD_LOGIC;
    we1        :  IN  STD_LOGIC;
    address1   :  IN  STD_LOGIC_VECTOR;
    din1       :  IN  STD_LOGIC_VECTOR;
    dout1      :  OUT STD_LOGIC_VECTOR;
    ready	     :  IN  STD_LOGIC;
    done	     :  IN  STD_LOGIC
  );
end component;

signal arrayC1_bias_ce0, arrayC1_bias_ce1 : STD_LOGIC;
signal arrayC1_bias_we0, arrayC1_bias_we1 : STD_LOGIC;
signal arrayC1_bias_address0, arrayC1_bias_address1 : STD_LOGIC_VECTOR(2 downto 0);
signal arrayC1_bias_din0, arrayC1_bias_din1 : STD_LOGIC_VECTOR(31 downto 0);
signal arrayC1_bias_dout0, arrayC1_bias_dout1 :  STD_LOGIC_VECTOR(31 downto 0);
signal arrayC1_bias_ready : STD_LOGIC;
signal arrayC1_bias_done : STD_LOGIC;

component AESL_automem_C1_bias is
  port(
    clk        :  IN  STD_LOGIC;
    rst        :  IN  STD_LOGIC;
    ce0        :  IN  STD_LOGIC;
    we0        :  IN  STD_LOGIC;
    address0   :  IN  STD_LOGIC_VECTOR;
    din0       :  IN  STD_LOGIC_VECTOR;
    dout0      :  OUT STD_LOGIC_VECTOR;
    ce1        :  IN  STD_LOGIC;
    we1        :  IN  STD_LOGIC;
    address1   :  IN  STD_LOGIC_VECTOR;
    din1       :  IN  STD_LOGIC_VECTOR;
    dout1      :  OUT STD_LOGIC_VECTOR;
    ready	     :  IN  STD_LOGIC;
    done	     :  IN  STD_LOGIC
  );
end component;

signal arrayC2_weight_ce0, arrayC2_weight_ce1 : STD_LOGIC;
signal arrayC2_weight_we0, arrayC2_weight_we1 : STD_LOGIC;
signal arrayC2_weight_address0, arrayC2_weight_address1 : STD_LOGIC_VECTOR(11 downto 0);
signal arrayC2_weight_din0, arrayC2_weight_din1 : STD_LOGIC_VECTOR(31 downto 0);
signal arrayC2_weight_dout0, arrayC2_weight_dout1 :  STD_LOGIC_VECTOR(31 downto 0);
signal arrayC2_weight_ready : STD_LOGIC;
signal arrayC2_weight_done : STD_LOGIC;

component AESL_automem_C2_weight is
  port(
    clk        :  IN  STD_LOGIC;
    rst        :  IN  STD_LOGIC;
    ce0        :  IN  STD_LOGIC;
    we0        :  IN  STD_LOGIC;
    address0   :  IN  STD_LOGIC_VECTOR;
    din0       :  IN  STD_LOGIC_VECTOR;
    dout0      :  OUT STD_LOGIC_VECTOR;
    ce1        :  IN  STD_LOGIC;
    we1        :  IN  STD_LOGIC;
    address1   :  IN  STD_LOGIC_VECTOR;
    din1       :  IN  STD_LOGIC_VECTOR;
    dout1      :  OUT STD_LOGIC_VECTOR;
    ready	     :  IN  STD_LOGIC;
    done	     :  IN  STD_LOGIC
  );
end component;

signal arrayC2_bias_ce0, arrayC2_bias_ce1 : STD_LOGIC;
signal arrayC2_bias_we0, arrayC2_bias_we1 : STD_LOGIC;
signal arrayC2_bias_address0, arrayC2_bias_address1 : STD_LOGIC_VECTOR(3 downto 0);
signal arrayC2_bias_din0, arrayC2_bias_din1 : STD_LOGIC_VECTOR(31 downto 0);
signal arrayC2_bias_dout0, arrayC2_bias_dout1 :  STD_LOGIC_VECTOR(31 downto 0);
signal arrayC2_bias_ready : STD_LOGIC;
signal arrayC2_bias_done : STD_LOGIC;

component AESL_automem_C2_bias is
  port(
    clk        :  IN  STD_LOGIC;
    rst        :  IN  STD_LOGIC;
    ce0        :  IN  STD_LOGIC;
    we0        :  IN  STD_LOGIC;
    address0   :  IN  STD_LOGIC_VECTOR;
    din0       :  IN  STD_LOGIC_VECTOR;
    dout0      :  OUT STD_LOGIC_VECTOR;
    ce1        :  IN  STD_LOGIC;
    we1        :  IN  STD_LOGIC;
    address1   :  IN  STD_LOGIC_VECTOR;
    din1       :  IN  STD_LOGIC_VECTOR;
    dout1      :  OUT STD_LOGIC_VECTOR;
    ready	     :  IN  STD_LOGIC;
    done	     :  IN  STD_LOGIC
  );
end component;

signal arrayC3_weight_ce0, arrayC3_weight_ce1 : STD_LOGIC;
signal arrayC3_weight_we0, arrayC3_weight_we1 : STD_LOGIC;
signal arrayC3_weight_address0, arrayC3_weight_address1 : STD_LOGIC_VECTOR(14 downto 0);
signal arrayC3_weight_din0, arrayC3_weight_din1 : STD_LOGIC_VECTOR(31 downto 0);
signal arrayC3_weight_dout0, arrayC3_weight_dout1 :  STD_LOGIC_VECTOR(31 downto 0);
signal arrayC3_weight_ready : STD_LOGIC;
signal arrayC3_weight_done : STD_LOGIC;

component AESL_automem_C3_weight is
  port(
    clk        :  IN  STD_LOGIC;
    rst        :  IN  STD_LOGIC;
    ce0        :  IN  STD_LOGIC;
    we0        :  IN  STD_LOGIC;
    address0   :  IN  STD_LOGIC_VECTOR;
    din0       :  IN  STD_LOGIC_VECTOR;
    dout0      :  OUT STD_LOGIC_VECTOR;
    ce1        :  IN  STD_LOGIC;
    we1        :  IN  STD_LOGIC;
    address1   :  IN  STD_LOGIC_VECTOR;
    din1       :  IN  STD_LOGIC_VECTOR;
    dout1      :  OUT STD_LOGIC_VECTOR;
    ready	     :  IN  STD_LOGIC;
    done	     :  IN  STD_LOGIC
  );
end component;

signal arrayC3_bias_ce0, arrayC3_bias_ce1 : STD_LOGIC;
signal arrayC3_bias_we0, arrayC3_bias_we1 : STD_LOGIC;
signal arrayC3_bias_address0, arrayC3_bias_address1 : STD_LOGIC_VECTOR(6 downto 0);
signal arrayC3_bias_din0, arrayC3_bias_din1 : STD_LOGIC_VECTOR(31 downto 0);
signal arrayC3_bias_dout0, arrayC3_bias_dout1 :  STD_LOGIC_VECTOR(31 downto 0);
signal arrayC3_bias_ready : STD_LOGIC;
signal arrayC3_bias_done : STD_LOGIC;

component AESL_automem_C3_bias is
  port(
    clk        :  IN  STD_LOGIC;
    rst        :  IN  STD_LOGIC;
    ce0        :  IN  STD_LOGIC;
    we0        :  IN  STD_LOGIC;
    address0   :  IN  STD_LOGIC_VECTOR;
    din0       :  IN  STD_LOGIC_VECTOR;
    dout0      :  OUT STD_LOGIC_VECTOR;
    ce1        :  IN  STD_LOGIC;
    we1        :  IN  STD_LOGIC;
    address1   :  IN  STD_LOGIC_VECTOR;
    din1       :  IN  STD_LOGIC_VECTOR;
    dout1      :  OUT STD_LOGIC_VECTOR;
    ready	     :  IN  STD_LOGIC;
    done	     :  IN  STD_LOGIC
  );
end component;

signal arrayF1_weight_ce0, arrayF1_weight_ce1 : STD_LOGIC;
signal arrayF1_weight_we0, arrayF1_weight_we1 : STD_LOGIC;
signal arrayF1_weight_address0, arrayF1_weight_address1 : STD_LOGIC_VECTOR(13 downto 0);
signal arrayF1_weight_din0, arrayF1_weight_din1 : STD_LOGIC_VECTOR(31 downto 0);
signal arrayF1_weight_dout0, arrayF1_weight_dout1 :  STD_LOGIC_VECTOR(31 downto 0);
signal arrayF1_weight_ready : STD_LOGIC;
signal arrayF1_weight_done : STD_LOGIC;

component AESL_automem_F1_weight is
  port(
    clk        :  IN  STD_LOGIC;
    rst        :  IN  STD_LOGIC;
    ce0        :  IN  STD_LOGIC;
    we0        :  IN  STD_LOGIC;
    address0   :  IN  STD_LOGIC_VECTOR;
    din0       :  IN  STD_LOGIC_VECTOR;
    dout0      :  OUT STD_LOGIC_VECTOR;
    ce1        :  IN  STD_LOGIC;
    we1        :  IN  STD_LOGIC;
    address1   :  IN  STD_LOGIC_VECTOR;
    din1       :  IN  STD_LOGIC_VECTOR;
    dout1      :  OUT STD_LOGIC_VECTOR;
    ready	     :  IN  STD_LOGIC;
    done	     :  IN  STD_LOGIC
  );
end component;

signal arrayF1_bias_ce0, arrayF1_bias_ce1 : STD_LOGIC;
signal arrayF1_bias_we0, arrayF1_bias_we1 : STD_LOGIC;
signal arrayF1_bias_address0, arrayF1_bias_address1 : STD_LOGIC_VECTOR(6 downto 0);
signal arrayF1_bias_din0, arrayF1_bias_din1 : STD_LOGIC_VECTOR(31 downto 0);
signal arrayF1_bias_dout0, arrayF1_bias_dout1 :  STD_LOGIC_VECTOR(31 downto 0);
signal arrayF1_bias_ready : STD_LOGIC;
signal arrayF1_bias_done : STD_LOGIC;

component AESL_automem_F1_bias is
  port(
    clk        :  IN  STD_LOGIC;
    rst        :  IN  STD_LOGIC;
    ce0        :  IN  STD_LOGIC;
    we0        :  IN  STD_LOGIC;
    address0   :  IN  STD_LOGIC_VECTOR;
    din0       :  IN  STD_LOGIC_VECTOR;
    dout0      :  OUT STD_LOGIC_VECTOR;
    ce1        :  IN  STD_LOGIC;
    we1        :  IN  STD_LOGIC;
    address1   :  IN  STD_LOGIC_VECTOR;
    din1       :  IN  STD_LOGIC_VECTOR;
    dout1      :  OUT STD_LOGIC_VECTOR;
    ready	     :  IN  STD_LOGIC;
    done	     :  IN  STD_LOGIC
  );
end component;

signal arrayF2_weight_ce0, arrayF2_weight_ce1 : STD_LOGIC;
signal arrayF2_weight_we0, arrayF2_weight_we1 : STD_LOGIC;
signal arrayF2_weight_address0, arrayF2_weight_address1 : STD_LOGIC_VECTOR(9 downto 0);
signal arrayF2_weight_din0, arrayF2_weight_din1 : STD_LOGIC_VECTOR(31 downto 0);
signal arrayF2_weight_dout0, arrayF2_weight_dout1 :  STD_LOGIC_VECTOR(31 downto 0);
signal arrayF2_weight_ready : STD_LOGIC;
signal arrayF2_weight_done : STD_LOGIC;

component AESL_automem_F2_weight is
  port(
    clk        :  IN  STD_LOGIC;
    rst        :  IN  STD_LOGIC;
    ce0        :  IN  STD_LOGIC;
    we0        :  IN  STD_LOGIC;
    address0   :  IN  STD_LOGIC_VECTOR;
    din0       :  IN  STD_LOGIC_VECTOR;
    dout0      :  OUT STD_LOGIC_VECTOR;
    ce1        :  IN  STD_LOGIC;
    we1        :  IN  STD_LOGIC;
    address1   :  IN  STD_LOGIC_VECTOR;
    din1       :  IN  STD_LOGIC_VECTOR;
    dout1      :  OUT STD_LOGIC_VECTOR;
    ready	     :  IN  STD_LOGIC;
    done	     :  IN  STD_LOGIC
  );
end component;

signal arrayF2_bias_ce0, arrayF2_bias_ce1 : STD_LOGIC;
signal arrayF2_bias_we0, arrayF2_bias_we1 : STD_LOGIC;
signal arrayF2_bias_address0, arrayF2_bias_address1 : STD_LOGIC_VECTOR(3 downto 0);
signal arrayF2_bias_din0, arrayF2_bias_din1 : STD_LOGIC_VECTOR(31 downto 0);
signal arrayF2_bias_dout0, arrayF2_bias_dout1 :  STD_LOGIC_VECTOR(31 downto 0);
signal arrayF2_bias_ready : STD_LOGIC;
signal arrayF2_bias_done : STD_LOGIC;

component AESL_automem_F2_bias is
  port(
    clk        :  IN  STD_LOGIC;
    rst        :  IN  STD_LOGIC;
    ce0        :  IN  STD_LOGIC;
    we0        :  IN  STD_LOGIC;
    address0   :  IN  STD_LOGIC_VECTOR;
    din0       :  IN  STD_LOGIC_VECTOR;
    dout0      :  OUT STD_LOGIC_VECTOR;
    ce1        :  IN  STD_LOGIC;
    we1        :  IN  STD_LOGIC;
    address1   :  IN  STD_LOGIC_VECTOR;
    din1       :  IN  STD_LOGIC_VECTOR;
    dout1      :  OUT STD_LOGIC_VECTOR;
    ready	     :  IN  STD_LOGIC;
    done	     :  IN  STD_LOGIC
  );
end component;

signal arrayInput_Test_Img_ce0, arrayInput_Test_Img_ce1 : STD_LOGIC;
signal arrayInput_Test_Img_we0, arrayInput_Test_Img_we1 : STD_LOGIC;
signal arrayInput_Test_Img_address0, arrayInput_Test_Img_address1 : STD_LOGIC_VECTOR(22 downto 0);
signal arrayInput_Test_Img_din0, arrayInput_Test_Img_din1 : STD_LOGIC_VECTOR(31 downto 0);
signal arrayInput_Test_Img_dout0, arrayInput_Test_Img_dout1 :  STD_LOGIC_VECTOR(31 downto 0);
signal arrayInput_Test_Img_ready : STD_LOGIC;
signal arrayInput_Test_Img_done : STD_LOGIC;

component AESL_automem_Input_Test_Img is
  port(
    clk        :  IN  STD_LOGIC;
    rst        :  IN  STD_LOGIC;
    ce0        :  IN  STD_LOGIC;
    we0        :  IN  STD_LOGIC;
    address0   :  IN  STD_LOGIC_VECTOR;
    din0       :  IN  STD_LOGIC_VECTOR;
    dout0      :  OUT STD_LOGIC_VECTOR;
    ce1        :  IN  STD_LOGIC;
    we1        :  IN  STD_LOGIC;
    address1   :  IN  STD_LOGIC_VECTOR;
    din1       :  IN  STD_LOGIC_VECTOR;
    dout1      :  OUT STD_LOGIC_VECTOR;
    ready	     :  IN  STD_LOGIC;
    done	     :  IN  STD_LOGIC
  );
end component;

signal arrayTest_Label_ce0, arrayTest_Label_ce1 : STD_LOGIC;
signal arrayTest_Label_we0, arrayTest_Label_we1 : STD_LOGIC;
signal arrayTest_Label_address0, arrayTest_Label_address1 : STD_LOGIC_VECTOR(16 downto 0);
signal arrayTest_Label_din0, arrayTest_Label_din1 : STD_LOGIC_VECTOR(31 downto 0);
signal arrayTest_Label_dout0, arrayTest_Label_dout1 :  STD_LOGIC_VECTOR(31 downto 0);
signal arrayTest_Label_ready : STD_LOGIC;
signal arrayTest_Label_done : STD_LOGIC;

component AESL_automem_Test_Label is
  port(
    clk        :  IN  STD_LOGIC;
    rst        :  IN  STD_LOGIC;
    ce0        :  IN  STD_LOGIC;
    we0        :  IN  STD_LOGIC;
    address0   :  IN  STD_LOGIC_VECTOR;
    din0       :  IN  STD_LOGIC_VECTOR;
    dout0      :  OUT STD_LOGIC_VECTOR;
    ce1        :  IN  STD_LOGIC;
    we1        :  IN  STD_LOGIC;
    address1   :  IN  STD_LOGIC_VECTOR;
    din1       :  IN  STD_LOGIC_VECTOR;
    dout1      :  OUT STD_LOGIC_VECTOR;
    ready	     :  IN  STD_LOGIC;
    done	     :  IN  STD_LOGIC
  );
end component;

shared variable AESL_REG_judge_ap_vld : STD_LOGIC := '0';
-- The signal of port judge
shared variable AESL_REG_judge : STD_LOGIC_VECTOR(0 downto 0) := (others => '0');
      procedure esl_read_token (file textfile: TEXT; textline: inout LINE; token: out STRING; token_len: out INTEGER) is
          variable whitespace : CHARACTER;
          variable i : INTEGER;
          variable ok: BOOLEAN;
          variable buff: STRING(1 to token'length);
      begin
          ok := false;
          i := 1;
          loop_main: while not endfile(textfile) loop
              if textline = null or textline'length = 0 then
                  readline(textfile, textline);
              end if;
              loop_remove_whitespace: while textline'length > 0 loop
                  if textline(textline'left) = ' ' or
                      textline(textline'left) = HT or
                      textline(textline'left) = CR or
                      textline(textline'left) = LF then
                      read(textline, whitespace);
                  else
                      exit loop_remove_whitespace;
                  end if;
              end loop;
              loop_aesl_read_token: while textline'length > 0 and i <= buff'length loop
                  if textline(textline'left) = ' ' or
                     textline(textline'left) = HT or
                     textline(textline'left) = CR or
                     textline(textline'left) = LF then
                      exit loop_aesl_read_token;
                  else
                      read(textline, buff(i));
                      i := i + 1;
                  end if;
                  ok := true;
              end loop;
              if ok = true then
                  exit loop_main;
              end if;
          end loop;
          buff(i) := ' ';
          token := buff;
          token_len:= i-1;
      end procedure esl_read_token;

      procedure esl_read_token (file textfile: TEXT;
                                textline: inout LINE;
                                token: out STRING) is
          variable i : INTEGER;
      begin
          esl_read_token (textfile, textline, token, i);
      end procedure esl_read_token;

      function esl_str2lv_hex (RHS : STRING; data_width : INTEGER) return STD_LOGIC_VECTOR is
          variable	ret	:   STD_LOGIC_VECTOR(data_width - 1 downto 0);
          variable	idx	:   integer := 3;
      begin
          ret := (others => '0');
          if(RHS(1) /= '0' and (RHS(2) /= 'x' or RHS(2) /= 'X')) then
     	        report "Error! The format of hex number is not initialed by 0x";
          end if;
          while true loop
              if (data_width > 4) then
                  case RHS(idx)  is
                      when '0'    =>  ret := ret(data_width - 5 downto 0) & "0000";
     	                when '1'    =>  ret := ret(data_width - 5 downto 0) & "0001";
                      when '2'    =>  ret := ret(data_width - 5 downto 0) & "0010";
                      when '3'    =>  ret := ret(data_width - 5 downto 0) & "0011";
                      when '4'    =>  ret := ret(data_width - 5 downto 0) & "0100";
                      when '5'    =>  ret := ret(data_width - 5 downto 0) & "0101";
                      when '6'    =>  ret := ret(data_width - 5 downto 0) & "0110";
                      when '7'    =>  ret := ret(data_width - 5 downto 0) & "0111";
                      when '8'    =>  ret := ret(data_width - 5 downto 0) & "1000";
                      when '9'    =>  ret := ret(data_width - 5 downto 0) & "1001";
                      when 'a' | 'A'  =>  ret := ret(data_width - 5 downto 0) & "1010";
                      when 'b' | 'B'  =>  ret := ret(data_width - 5 downto 0) & "1011";
                      when 'c' | 'C'  =>  ret := ret(data_width - 5 downto 0) & "1100";
                      when 'd' | 'D'  =>  ret := ret(data_width - 5 downto 0) & "1101";
                      when 'e' | 'E'  =>  ret := ret(data_width - 5 downto 0) & "1110";
                      when 'f' | 'F'  =>  ret := ret(data_width - 5 downto 0) & "1111";
                      when 'x' | 'X'  =>  ret := ret(data_width - 5 downto 0) & "XXXX";
                      when ' '    =>  return ret;
                      when others    =>  report "Wrong hex char " & RHS(idx);	return ret;
                  end case;
              elsif (data_width = 4) then
                  case RHS(idx)  is
                      when '0'    =>  ret := "0000";
     	                when '1'    =>  ret := "0001";
                      when '2'    =>  ret := "0010";
                      when '3'    =>  ret := "0011";
                      when '4'    =>  ret := "0100";
                      when '5'    =>  ret := "0101";
                      when '6'    =>  ret := "0110";
                      when '7'    =>  ret := "0111";
                      when '8'    =>  ret := "1000";
                      when '9'    =>  ret := "1001";
                      when 'a' | 'A'  =>  ret := "1010";
                      when 'b' | 'B'  =>  ret := "1011";
                      when 'c' | 'C'  =>  ret := "1100";
                      when 'd' | 'D'  =>  ret := "1101";
                      when 'e' | 'E'  =>  ret := "1110";
                      when 'f' | 'F'  =>  ret := "1111";
                      when 'x' | 'X'  =>  ret := "XXXX";
                      when ' '    =>  return ret;
                      when others    =>  report "Wrong hex char " & RHS(idx);	return ret;
                  end case;
              elsif (data_width = 3) then
                  case RHS(idx)  is
                      when '0'    =>  ret := "000";
     	                when '1'    =>  ret := "001";
                      when '2'    =>  ret := "010";
                      when '3'    =>  ret := "011";
                      when '4'    =>  ret := "100";
                      when '5'    =>  ret := "101";
                      when '6'    =>  ret := "110";
                      when '7'    =>  ret := "111";
                      when 'x' | 'X'  =>  ret := "XXX";
                      when ' '    =>  return ret;
                      when others    =>  report "Wrong hex char " & RHS(idx);	return ret;
                  end case;
              elsif (data_width = 2) then
                  case RHS(idx)  is
                      when '0'    =>  ret := "00";
     	                when '1'    =>  ret := "01";
                      when '2'    =>  ret := "10";
                      when '3'    =>  ret := "11";
                      when 'x' | 'X'  =>  ret := "XX";
                      when ' '    =>  return ret;
                      when others    =>  report "Wrong hex char " & RHS(idx);	return ret;
                  end case;
              elsif (data_width = 1) then
                  case RHS(idx)  is
                      when '0'    =>  ret := "0";
     	                when '1'    =>  ret := "1";
                      when 'x' | 'X'  =>  ret := "X";
                      when ' '    =>  return ret;
                      when others    =>  report "Wrong hex char " & RHS(idx);	return ret;
                  end case;
              else
                  report string'("Wrong data_width.");
                  return ret;
              end if;
              idx := idx + 1;
          end loop;
          return ret;
      end function;

    function esl_str_dec2int (RHS : STRING) return INTEGER is
        variable	ret	:   integer;
        variable	idx	:   integer := 1;
    begin
        ret := 0;
        while true loop
            case RHS(idx)  is
                when '0'    =>  ret := ret * 10 + 0;
                when '1'    =>  ret := ret * 10 + 1;
                when '2'    =>  ret := ret * 10 + 2;
                when '3'    =>  ret := ret * 10 + 3;
                when '4'    =>  ret := ret * 10 + 4;
                when '5'    =>  ret := ret * 10 + 5;
                when '6'    =>  ret := ret * 10 + 6;
                when '7'    =>  ret := ret * 10 + 7;
                when '8'    =>  ret := ret * 10 + 8;
                when '9'    =>  ret := ret * 10 + 9;
                when ' '    =>  return ret;
                when others    =>  report "Wrong dec char " & RHS(idx);	return ret;
            end case;
            idx := idx + 1;
        end loop;
        return ret;
    end esl_str_dec2int;
      function esl_conv_string_hex (lv : STD_LOGIC_VECTOR) return STRING is
          constant str_len : integer := (lv'length + 3)/4;
          variable ret : STRING (1 to str_len);
          variable i, tmp: INTEGER;
          variable normal_lv : STD_LOGIC_VECTOR(lv'length - 1 downto 0);
          variable tmp_lv : STD_LOGIC_VECTOR(3 downto 0);
      begin
          normal_lv := lv;
          for i in 1 to str_len loop
              if(i = 1) then
                  if((lv'length mod 4) = 3) then
                      tmp_lv(2 downto 0) := normal_lv(lv'length - 1 downto lv'length - 3);
                      case tmp_lv(2 downto 0) is
                          when "000" => ret(i) := '0';
                          when "001" => ret(i) := '1';
                          when "010" => ret(i) := '2';
                          when "011" => ret(i) := '3';
                          when "100" => ret(i) := '4';
                          when "101" => ret(i) := '5';
                          when "110" => ret(i) := '6';
                          when "111" => ret(i) := '7';
                          when others  => ret(i) := 'X';
                      end case;
                  elsif((lv'length mod 4) = 2) then
                      tmp_lv(1 downto 0) := normal_lv(lv'length - 1 downto lv'length - 2);
                      case tmp_lv(1 downto 0) is
                          when "00" => ret(i) := '0';
                          when "01" => ret(i) := '1';
                          when "10" => ret(i) := '2';
                          when "11" => ret(i) := '3';
                          when others => ret(i) := 'X';
                      end case;
                  elsif((lv'length mod 4) = 1) then
                      tmp_lv(0 downto 0) := normal_lv(lv'length - 1 downto lv'length - 1);
                      case tmp_lv(0 downto 0) is
                          when "0" => ret(i) := '0';
                          when "1" => ret(i) := '1';
                          when others=> ret(i) := 'X';
                      end case;
                  elsif((lv'length mod 4) = 0) then
                      tmp_lv(3 downto 0) := normal_lv(lv'length - 1 downto lv'length - 4);
                      case tmp_lv(3 downto 0) is
                          when "0000" => ret(i) := '0';
                          when "0001" => ret(i) := '1';
                          when "0010" => ret(i) := '2';
                          when "0011" => ret(i) := '3';
                          when "0100" => ret(i) := '4';
                          when "0101" => ret(i) := '5';
                          when "0110" => ret(i) := '6';
                          when "0111" => ret(i) := '7';
                          when "1000" => ret(i) := '8';
                          when "1001" => ret(i) := '9';
                          when "1010" => ret(i) := 'a';
                          when "1011" => ret(i) := 'b';
                          when "1100" => ret(i) := 'c';
                          when "1101" => ret(i) := 'd';
                          when "1110" => ret(i) := 'e';
                          when "1111" => ret(i) := 'f';
                          when others   => ret(i) := 'X';
                      end case;
                  end if;
              else
                  tmp_lv(3 downto 0) := normal_lv((str_len - i) * 4 + 3 downto (str_len - i) * 4);
                  case tmp_lv(3 downto 0) is
                      when "0000" => ret(i) := '0';
                      when "0001" => ret(i) := '1';
                      when "0010" => ret(i) := '2';
                      when "0011" => ret(i) := '3';
                      when "0100" => ret(i) := '4';
                      when "0101" => ret(i) := '5';
                      when "0110" => ret(i) := '6';
                      when "0111" => ret(i) := '7';
                      when "1000" => ret(i) := '8';
                      when "1001" => ret(i) := '9';
                      when "1010" => ret(i) := 'a';
                      when "1011" => ret(i) := 'b';
                      when "1100" => ret(i) := 'c';
                      when "1101" => ret(i) := 'd';
                      when "1110" => ret(i) := 'e';
                      when "1111" => ret(i) := 'f';
                      when others   => ret(i) := 'X';
                  end case;
              end if;
          end loop;
          return ret;
      end function;

  -- purpose: initialise the random state variable based on an integer seed
  function init_rand(seed : integer) return T_RANDINT is
    variable result : T_RANDINT;
  begin
    -- If the seed is smaller than the minimum value of the random state variable, use the minimum value
    if seed < T_RANDINT'low then
      result := T_RANDINT'low;
      -- If the seed is larger than the maximum value of the random state variable, use the maximum value
    elsif seed > T_RANDINT'high then
      result := T_RANDINT'high;
      -- If the seed is within the range of the random state variable, just use the seed
    else
      result := seed;
    end if;
    -- Return the result
    return result;
  end init_rand;


  -- purpose: generate a random integer between min and max limits
  procedure rand_int(variable rand   : inout T_RANDINT;
                     constant minval : in    integer;
                     constant maxval : in    integer;
                     variable result : out   integer
                     ) is

    variable k, q      : integer;
    variable real_rand : real;
    variable res       : integer;

  begin
    -- Create a new random integer in the range 1 to 2**31-1 and put it back into rand VARIABLE
    -- Based on an example from Numerical Recipes in C, 2nd Edition, page 279
    k   := rand/127773;
    q   := 16807*(rand-k*127773)-2836*k;
    if q < 0 then
      q := q + 2147483647;
    end if;
    rand := init_rand(q);

    -- Convert this integer to a real number in the range 0 to 1
    real_rand := (real(rand - T_RANDINT'low)) / real(T_RANDINT'high - T_RANDINT'low);
    -- Convert this real number to an integer in the range minval to maxval
    -- The +1 and -0.5 are to get equal probability of minval and maxval as other values
    res    := integer((real_rand * real(maxval+1-minval)) - 0.5) + minval;
    -- VHDL real to integer conversion doesn't define what happens for x.5 so deal with this
    if res < minval then
      res  := minval;
    elsif res > maxval then
      res  := maxval;
    end if;
    -- assign output
    result := res;

  end rand_int;

      function esl_equal_std_lv (lv1 : STD_LOGIC_VECTOR; lv2 : STD_LOGIC_VECTOR) return BOOLEAN is
          variable len    : INTEGER;
          variable i      : INTEGER;
      begin
          if (lv1'length > lv2'length) then
              len := lv2'length;
              for i in lv1'length - 1 downto lv2'length loop
                  if(lv1(i) = '1') then
                      return false;
                  end if;
              end loop;
          else
              len := lv1'length;
              for i in lv2'length - 1 downto lv1'length loop
                  if(lv2(i) = '1') then
                      return false;
                  end if;
              end loop;
          end if;
          for i in len - 1 downto 0 loop
              if (lv1(i) = '1' and lv2(i) /= '1') or (lv1(i) = '0' and lv2(i) /= '0') then
                  return false;
              end if;
          end loop;
          return true;
      end function;

      procedure post_check (file fp1 : TEXT; file fp2 : TEXT) is
          variable    token_line1 :   LINE;
          variable    token_line2 :   LINE;
          variable    token1      :   STRING(1 to 208);
          variable    token2      :   STRING(1 to 208);
          variable    golden      :   STD_LOGIC_VECTOR(207 downto 0);
          variable    result      :   STD_LOGIC_VECTOR(207 downto 0);
          variable    l1          :   INTEGER;
          variable    l2          :   INTEGER;
      begin
          esl_read_token(fp1, token_line1, token1);
          esl_read_token(fp2, token_line2, token2);
          if(token1(1 to 13) /= "[[[runtime]]]" or token2(1 to 13) /= "[[[runtime]]]") then
              assert false report "ERROR: Simulation using HLS TB failed." severity failure;
          end if;
          esl_read_token(fp1, token_line1, token1);
          esl_read_token(fp2, token_line2, token2);
          while(token1(1 to 14) /= "[[[/runtime]]]" and token2(1 to 14) /= "[[[/runtime]]]") loop
              if(token1(1 to 15) /= "[[transaction]]" and token2(1 to 15) /= "[[transaction]]") then
                  assert false report "ERROR: Simulation using HLS TB failed." severity failure;
              end if;
              esl_read_token(fp1, token_line1, token1);  -- Skip transaction number
              esl_read_token(fp2, token_line2, token2);  -- Skip transaction number
              esl_read_token(fp1, token_line1, token1, l1);
              esl_read_token(fp2, token_line2, token2, l2);
              while(token1(1 to 16) /= "[[/transaction]]" and token2(1 to 16) /= "[[/transaction]]") loop
                  golden := esl_str2lv_hex(token1, 208 );
                  result := esl_str2lv_hex(token2, 208 );
                  if(esl_equal_std_lv(golden, result) = false) then
                      report token1(1 to l1) & " (expected) vs. " & token2(1 to l2) & " (actual) - mismatch";
                      assert false report "ERROR: Simulation using HLS TB failed." severity failure;
                  end if;
                  esl_read_token(fp1, token_line1, token1);
                  esl_read_token(fp2, token_line2, token2);
              end loop;
              esl_read_token(fp1, token_line1, token1);
              esl_read_token(fp2, token_line2, token2);
          end loop;
      end procedure post_check;

begin
AESL_inst_infer_only    :   infer_only port map (
   ap_clk  =>  ap_clk,
   ap_rst  =>  ap_rst,
   ap_start  =>  ap_start,
   ap_done  =>  ap_done,
   ap_idle  =>  ap_idle,
   ap_ready  =>  ap_ready,
   C1_weight_address0  =>  C1_weight_address0,
   C1_weight_ce0  =>  C1_weight_ce0,
   C1_weight_q0  =>  C1_weight_q0,
   C1_bias_address0  =>  C1_bias_address0,
   C1_bias_ce0  =>  C1_bias_ce0,
   C1_bias_q0  =>  C1_bias_q0,
   C2_weight_address0  =>  C2_weight_address0,
   C2_weight_ce0  =>  C2_weight_ce0,
   C2_weight_q0  =>  C2_weight_q0,
   C2_bias_address0  =>  C2_bias_address0,
   C2_bias_ce0  =>  C2_bias_ce0,
   C2_bias_q0  =>  C2_bias_q0,
   C3_weight_address0  =>  C3_weight_address0,
   C3_weight_ce0  =>  C3_weight_ce0,
   C3_weight_q0  =>  C3_weight_q0,
   C3_bias_address0  =>  C3_bias_address0,
   C3_bias_ce0  =>  C3_bias_ce0,
   C3_bias_q0  =>  C3_bias_q0,
   F1_weight_address0  =>  F1_weight_address0,
   F1_weight_ce0  =>  F1_weight_ce0,
   F1_weight_q0  =>  F1_weight_q0,
   F1_bias_address0  =>  F1_bias_address0,
   F1_bias_ce0  =>  F1_bias_ce0,
   F1_bias_q0  =>  F1_bias_q0,
   F2_weight_address0  =>  F2_weight_address0,
   F2_weight_ce0  =>  F2_weight_ce0,
   F2_weight_q0  =>  F2_weight_q0,
   F2_bias_address0  =>  F2_bias_address0,
   F2_bias_ce0  =>  F2_bias_ce0,
   F2_bias_q0  =>  F2_bias_q0,
   Input_Test_Img_address0  =>  Input_Test_Img_address0,
   Input_Test_Img_ce0  =>  Input_Test_Img_ce0,
   Input_Test_Img_q0  =>  Input_Test_Img_q0,
   Test_Label_address0  =>  Test_Label_address0,
   Test_Label_ce0  =>  Test_Label_ce0,
   Test_Label_q0  =>  Test_Label_q0,
   judge  =>  judge,
   judge_ap_vld  =>  judge_ap_vld
);

-- Assignment for control signal
  ap_clk <= AESL_clock;
  ap_rst <= AESL_reset;
  AESL_reset <= rst;
  ap_start <= AESL_start;
  AESL_start <= start;
  AESL_done <= ap_done;
  AESL_idle <= ap_idle;
  AESL_ready <= ap_ready;
  AESL_ce <= ce;
  AESL_continue <= continue;
gen_check_strlSignal_AESL_done_proc : process(AESL_clock)
begin
  if (AESL_clock'event and AESL_clock = '1') then
    if(AESL_reset = '1') then
      NULL;
    else
        if ( AESL_done /= '1' and AESL_done /= '0' ) then
            assert false report "Control signal AESL_done is invalid!" severity failure;
        end if;
    end if;
  end if;
end process;
gen_check_strlSignal_AESL_ready_proc : process(AESL_clock)
begin
  if (AESL_clock'event and AESL_clock = '1') then
    if(AESL_reset = '1') then
      NULL;
    else
        if ( AESL_ready /= '1' and AESL_ready /= '0' ) then
            assert false report "Control signal AESL_ready is invalid!" severity failure;
        end if;
    end if;
  end if;
end process;
AESL_inst_C1_weight : AESL_automem_C1_weight port map (
    clk       =>  AESL_clock,
    rst       =>  AESL_reset,
    ce0       =>  arrayC1_weight_ce0,
    we0       =>  arrayC1_weight_we0,
    address0  =>  arrayC1_weight_address0,
    din0      =>  arrayC1_weight_din0,
    dout0     =>  arrayC1_weight_dout0,
    ce1       =>  arrayC1_weight_ce1,
    we1       =>  arrayC1_weight_we1,
    address1  =>  arrayC1_weight_address1,
    din1      =>  arrayC1_weight_din1,
    dout1     =>  arrayC1_weight_dout1,
    ready	    =>  arrayC1_weight_ready,
    done	    =>  arrayC1_weight_done
);

-- Assignment between dut and arrayC1_weight
arrayC1_weight_address0 <= C1_weight_address0;
arrayC1_weight_ce0 <= C1_weight_ce0;
C1_weight_q0 <= arrayC1_weight_dout0;
arrayC1_weight_we0 <= '0';
arrayC1_weight_din0 <= (others => '0');
arrayC1_weight_we1 <= '0';
arrayC1_weight_din1 <= (others => '0');
arrayC1_weight_ready <=	ready;
arrayC1_weight_done <= '0';

AESL_inst_C1_bias : AESL_automem_C1_bias port map (
    clk       =>  AESL_clock,
    rst       =>  AESL_reset,
    ce0       =>  arrayC1_bias_ce0,
    we0       =>  arrayC1_bias_we0,
    address0  =>  arrayC1_bias_address0,
    din0      =>  arrayC1_bias_din0,
    dout0     =>  arrayC1_bias_dout0,
    ce1       =>  arrayC1_bias_ce1,
    we1       =>  arrayC1_bias_we1,
    address1  =>  arrayC1_bias_address1,
    din1      =>  arrayC1_bias_din1,
    dout1     =>  arrayC1_bias_dout1,
    ready	    =>  arrayC1_bias_ready,
    done	    =>  arrayC1_bias_done
);

-- Assignment between dut and arrayC1_bias
arrayC1_bias_address0 <= C1_bias_address0;
arrayC1_bias_ce0 <= C1_bias_ce0;
C1_bias_q0 <= arrayC1_bias_dout0;
arrayC1_bias_we0 <= '0';
arrayC1_bias_din0 <= (others => '0');
arrayC1_bias_we1 <= '0';
arrayC1_bias_din1 <= (others => '0');
arrayC1_bias_ready <=	ready;
arrayC1_bias_done <= '0';

AESL_inst_C2_weight : AESL_automem_C2_weight port map (
    clk       =>  AESL_clock,
    rst       =>  AESL_reset,
    ce0       =>  arrayC2_weight_ce0,
    we0       =>  arrayC2_weight_we0,
    address0  =>  arrayC2_weight_address0,
    din0      =>  arrayC2_weight_din0,
    dout0     =>  arrayC2_weight_dout0,
    ce1       =>  arrayC2_weight_ce1,
    we1       =>  arrayC2_weight_we1,
    address1  =>  arrayC2_weight_address1,
    din1      =>  arrayC2_weight_din1,
    dout1     =>  arrayC2_weight_dout1,
    ready	    =>  arrayC2_weight_ready,
    done	    =>  arrayC2_weight_done
);

-- Assignment between dut and arrayC2_weight
arrayC2_weight_address0 <= C2_weight_address0;
arrayC2_weight_ce0 <= C2_weight_ce0;
C2_weight_q0 <= arrayC2_weight_dout0;
arrayC2_weight_we0 <= '0';
arrayC2_weight_din0 <= (others => '0');
arrayC2_weight_we1 <= '0';
arrayC2_weight_din1 <= (others => '0');
arrayC2_weight_ready <=	ready;
arrayC2_weight_done <= '0';

AESL_inst_C2_bias : AESL_automem_C2_bias port map (
    clk       =>  AESL_clock,
    rst       =>  AESL_reset,
    ce0       =>  arrayC2_bias_ce0,
    we0       =>  arrayC2_bias_we0,
    address0  =>  arrayC2_bias_address0,
    din0      =>  arrayC2_bias_din0,
    dout0     =>  arrayC2_bias_dout0,
    ce1       =>  arrayC2_bias_ce1,
    we1       =>  arrayC2_bias_we1,
    address1  =>  arrayC2_bias_address1,
    din1      =>  arrayC2_bias_din1,
    dout1     =>  arrayC2_bias_dout1,
    ready	    =>  arrayC2_bias_ready,
    done	    =>  arrayC2_bias_done
);

-- Assignment between dut and arrayC2_bias
arrayC2_bias_address0 <= C2_bias_address0;
arrayC2_bias_ce0 <= C2_bias_ce0;
C2_bias_q0 <= arrayC2_bias_dout0;
arrayC2_bias_we0 <= '0';
arrayC2_bias_din0 <= (others => '0');
arrayC2_bias_we1 <= '0';
arrayC2_bias_din1 <= (others => '0');
arrayC2_bias_ready <=	ready;
arrayC2_bias_done <= '0';

AESL_inst_C3_weight : AESL_automem_C3_weight port map (
    clk       =>  AESL_clock,
    rst       =>  AESL_reset,
    ce0       =>  arrayC3_weight_ce0,
    we0       =>  arrayC3_weight_we0,
    address0  =>  arrayC3_weight_address0,
    din0      =>  arrayC3_weight_din0,
    dout0     =>  arrayC3_weight_dout0,
    ce1       =>  arrayC3_weight_ce1,
    we1       =>  arrayC3_weight_we1,
    address1  =>  arrayC3_weight_address1,
    din1      =>  arrayC3_weight_din1,
    dout1     =>  arrayC3_weight_dout1,
    ready	    =>  arrayC3_weight_ready,
    done	    =>  arrayC3_weight_done
);

-- Assignment between dut and arrayC3_weight
arrayC3_weight_address0 <= C3_weight_address0;
arrayC3_weight_ce0 <= C3_weight_ce0;
C3_weight_q0 <= arrayC3_weight_dout0;
arrayC3_weight_we0 <= '0';
arrayC3_weight_din0 <= (others => '0');
arrayC3_weight_we1 <= '0';
arrayC3_weight_din1 <= (others => '0');
arrayC3_weight_ready <=	ready;
arrayC3_weight_done <= '0';

AESL_inst_C3_bias : AESL_automem_C3_bias port map (
    clk       =>  AESL_clock,
    rst       =>  AESL_reset,
    ce0       =>  arrayC3_bias_ce0,
    we0       =>  arrayC3_bias_we0,
    address0  =>  arrayC3_bias_address0,
    din0      =>  arrayC3_bias_din0,
    dout0     =>  arrayC3_bias_dout0,
    ce1       =>  arrayC3_bias_ce1,
    we1       =>  arrayC3_bias_we1,
    address1  =>  arrayC3_bias_address1,
    din1      =>  arrayC3_bias_din1,
    dout1     =>  arrayC3_bias_dout1,
    ready	    =>  arrayC3_bias_ready,
    done	    =>  arrayC3_bias_done
);

-- Assignment between dut and arrayC3_bias
arrayC3_bias_address0 <= C3_bias_address0;
arrayC3_bias_ce0 <= C3_bias_ce0;
C3_bias_q0 <= arrayC3_bias_dout0;
arrayC3_bias_we0 <= '0';
arrayC3_bias_din0 <= (others => '0');
arrayC3_bias_we1 <= '0';
arrayC3_bias_din1 <= (others => '0');
arrayC3_bias_ready <=	ready;
arrayC3_bias_done <= '0';

AESL_inst_F1_weight : AESL_automem_F1_weight port map (
    clk       =>  AESL_clock,
    rst       =>  AESL_reset,
    ce0       =>  arrayF1_weight_ce0,
    we0       =>  arrayF1_weight_we0,
    address0  =>  arrayF1_weight_address0,
    din0      =>  arrayF1_weight_din0,
    dout0     =>  arrayF1_weight_dout0,
    ce1       =>  arrayF1_weight_ce1,
    we1       =>  arrayF1_weight_we1,
    address1  =>  arrayF1_weight_address1,
    din1      =>  arrayF1_weight_din1,
    dout1     =>  arrayF1_weight_dout1,
    ready	    =>  arrayF1_weight_ready,
    done	    =>  arrayF1_weight_done
);

-- Assignment between dut and arrayF1_weight
arrayF1_weight_address0 <= F1_weight_address0;
arrayF1_weight_ce0 <= F1_weight_ce0;
F1_weight_q0 <= arrayF1_weight_dout0;
arrayF1_weight_we0 <= '0';
arrayF1_weight_din0 <= (others => '0');
arrayF1_weight_we1 <= '0';
arrayF1_weight_din1 <= (others => '0');
arrayF1_weight_ready <=	ready;
arrayF1_weight_done <= '0';

AESL_inst_F1_bias : AESL_automem_F1_bias port map (
    clk       =>  AESL_clock,
    rst       =>  AESL_reset,
    ce0       =>  arrayF1_bias_ce0,
    we0       =>  arrayF1_bias_we0,
    address0  =>  arrayF1_bias_address0,
    din0      =>  arrayF1_bias_din0,
    dout0     =>  arrayF1_bias_dout0,
    ce1       =>  arrayF1_bias_ce1,
    we1       =>  arrayF1_bias_we1,
    address1  =>  arrayF1_bias_address1,
    din1      =>  arrayF1_bias_din1,
    dout1     =>  arrayF1_bias_dout1,
    ready	    =>  arrayF1_bias_ready,
    done	    =>  arrayF1_bias_done
);

-- Assignment between dut and arrayF1_bias
arrayF1_bias_address0 <= F1_bias_address0;
arrayF1_bias_ce0 <= F1_bias_ce0;
F1_bias_q0 <= arrayF1_bias_dout0;
arrayF1_bias_we0 <= '0';
arrayF1_bias_din0 <= (others => '0');
arrayF1_bias_we1 <= '0';
arrayF1_bias_din1 <= (others => '0');
arrayF1_bias_ready <=	ready;
arrayF1_bias_done <= '0';

AESL_inst_F2_weight : AESL_automem_F2_weight port map (
    clk       =>  AESL_clock,
    rst       =>  AESL_reset,
    ce0       =>  arrayF2_weight_ce0,
    we0       =>  arrayF2_weight_we0,
    address0  =>  arrayF2_weight_address0,
    din0      =>  arrayF2_weight_din0,
    dout0     =>  arrayF2_weight_dout0,
    ce1       =>  arrayF2_weight_ce1,
    we1       =>  arrayF2_weight_we1,
    address1  =>  arrayF2_weight_address1,
    din1      =>  arrayF2_weight_din1,
    dout1     =>  arrayF2_weight_dout1,
    ready	    =>  arrayF2_weight_ready,
    done	    =>  arrayF2_weight_done
);

-- Assignment between dut and arrayF2_weight
arrayF2_weight_address0 <= F2_weight_address0;
arrayF2_weight_ce0 <= F2_weight_ce0;
F2_weight_q0 <= arrayF2_weight_dout0;
arrayF2_weight_we0 <= '0';
arrayF2_weight_din0 <= (others => '0');
arrayF2_weight_we1 <= '0';
arrayF2_weight_din1 <= (others => '0');
arrayF2_weight_ready <=	ready;
arrayF2_weight_done <= '0';

AESL_inst_F2_bias : AESL_automem_F2_bias port map (
    clk       =>  AESL_clock,
    rst       =>  AESL_reset,
    ce0       =>  arrayF2_bias_ce0,
    we0       =>  arrayF2_bias_we0,
    address0  =>  arrayF2_bias_address0,
    din0      =>  arrayF2_bias_din0,
    dout0     =>  arrayF2_bias_dout0,
    ce1       =>  arrayF2_bias_ce1,
    we1       =>  arrayF2_bias_we1,
    address1  =>  arrayF2_bias_address1,
    din1      =>  arrayF2_bias_din1,
    dout1     =>  arrayF2_bias_dout1,
    ready	    =>  arrayF2_bias_ready,
    done	    =>  arrayF2_bias_done
);

-- Assignment between dut and arrayF2_bias
arrayF2_bias_address0 <= F2_bias_address0;
arrayF2_bias_ce0 <= F2_bias_ce0;
F2_bias_q0 <= arrayF2_bias_dout0;
arrayF2_bias_we0 <= '0';
arrayF2_bias_din0 <= (others => '0');
arrayF2_bias_we1 <= '0';
arrayF2_bias_din1 <= (others => '0');
arrayF2_bias_ready <=	ready;
arrayF2_bias_done <= '0';

AESL_inst_Input_Test_Img : AESL_automem_Input_Test_Img port map (
    clk       =>  AESL_clock,
    rst       =>  AESL_reset,
    ce0       =>  arrayInput_Test_Img_ce0,
    we0       =>  arrayInput_Test_Img_we0,
    address0  =>  arrayInput_Test_Img_address0,
    din0      =>  arrayInput_Test_Img_din0,
    dout0     =>  arrayInput_Test_Img_dout0,
    ce1       =>  arrayInput_Test_Img_ce1,
    we1       =>  arrayInput_Test_Img_we1,
    address1  =>  arrayInput_Test_Img_address1,
    din1      =>  arrayInput_Test_Img_din1,
    dout1     =>  arrayInput_Test_Img_dout1,
    ready	    =>  arrayInput_Test_Img_ready,
    done	    =>  arrayInput_Test_Img_done
);

-- Assignment between dut and arrayInput_Test_Img
arrayInput_Test_Img_address0 <= Input_Test_Img_address0;
arrayInput_Test_Img_ce0 <= Input_Test_Img_ce0;
Input_Test_Img_q0 <= arrayInput_Test_Img_dout0;
arrayInput_Test_Img_we0 <= '0';
arrayInput_Test_Img_din0 <= (others => '0');
arrayInput_Test_Img_we1 <= '0';
arrayInput_Test_Img_din1 <= (others => '0');
arrayInput_Test_Img_ready <=	ready;
arrayInput_Test_Img_done <= '0';

AESL_inst_Test_Label : AESL_automem_Test_Label port map (
    clk       =>  AESL_clock,
    rst       =>  AESL_reset,
    ce0       =>  arrayTest_Label_ce0,
    we0       =>  arrayTest_Label_we0,
    address0  =>  arrayTest_Label_address0,
    din0      =>  arrayTest_Label_din0,
    dout0     =>  arrayTest_Label_dout0,
    ce1       =>  arrayTest_Label_ce1,
    we1       =>  arrayTest_Label_we1,
    address1  =>  arrayTest_Label_address1,
    din1      =>  arrayTest_Label_din1,
    dout1     =>  arrayTest_Label_dout1,
    ready	    =>  arrayTest_Label_ready,
    done	    =>  arrayTest_Label_done
);

-- Assignment between dut and arrayTest_Label
arrayTest_Label_address0 <= Test_Label_address0;
arrayTest_Label_ce0 <= Test_Label_ce0;
Test_Label_q0 <= arrayTest_Label_dout0;
arrayTest_Label_we0 <= '0';
arrayTest_Label_din0 <= (others => '0');
arrayTest_Label_we1 <= '0';
arrayTest_Label_din1 <= (others => '0');
arrayTest_Label_ready <=	ready;
arrayTest_Label_done <= '0';

gen_out_judge_proc : process(AESL_clock)
begin
  if (AESL_clock'event and AESL_clock = '1') then
    if(AESL_reset = '1') then
        AESL_REG_judge := (others => '0'); 
    elsif(judge_ap_vld = '1') then
        AESL_REG_judge(0) := judge;
        AESL_REG_judge_ap_vld := '1';
    end if;
  end if;
end process;

write_file_process_judge : process
    file      fp              :   TEXT;
    file      fp_size         :   TEXT;
    variable  fstatus         :   FILE_OPEN_STATUS;
    variable  token_line      :   LINE;
    variable  token           :   STRING(1 to 208);
    variable  str             :   STRING(1 to 40);
    variable  transaction_idx :   INTEGER;
    variable  judge_count   :   INTEGER;
    variable  hls_stream_size :   INTEGER;
    variable  i               :   INTEGER;
    variable  rand            :   T_RANDINT     := init_rand(0);
    variable  rint            :   INTEGER;
begin
    wait until AESL_reset = '0';
    file_open(fstatus, fp, AUTOTB_TVOUT_judge_out_wrapc, WRITE_MODE);
    if(fstatus /= OPEN_OK) then
        assert false report "Open file " & AUTOTB_TVOUT_judge_out_wrapc & " failed!!!" severity note;
        assert false report "ERROR: Simulation using HLS TB failed." severity failure;
    end if;
    write(token_line, string'("[[[runtime]]]"));
    writeline(fp, token_line);
    transaction_idx := 0;
    while (transaction_idx /= AUTOTB_TRANSACTION_NUM) loop
        wait until AESL_clock'event and AESL_clock = '1';
	      while(AESL_done /= '1') loop
            wait until AESL_clock'event and AESL_clock = '1';
	      end loop;
        wait for 0.4 ns;
        write(token_line, string'("[[transaction]]    ") & integer'image(transaction_idx));
        writeline(fp, token_line);
        if(AESL_REG_judge_ap_vld = '1')  then
            write(token_line, "0x" & esl_conv_string_hex(AESL_REG_judge));
            writeline(fp, token_line);
            AESL_REG_judge_ap_vld := '0';
        end if;
        transaction_idx := transaction_idx + 1;
        write(token_line, string'("[[/transaction]]"));
        writeline(fp, token_line);
    end loop;
    write(token_line, string'("[[[/runtime]]]"));
    writeline(fp, token_line);
    file_close(fp);
    wait;
end process;

generate_ready_cnt_proc : process(ready_initial, AESL_clock)
begin
    if(AESL_clock'event and AESL_clock = '0') then
        if(ready_initial = '1') then
            ready_cnt <= conv_std_logic_vector(1, 32);
        end if;
    elsif(AESL_clock'event and AESL_clock = '1') then
        if(ready_cnt /= AUTOTB_TRANSACTION_NUM) then
            if(AESL_ready = '1') then
                ready_cnt <= ready_cnt + 1;
            end if;
        end if;
    end if;
end process;

generate_done_cnt_proc : process(AESL_reset, AESL_clock)
begin
    if(AESL_reset = '1') then
        done_cnt <= (others => '0');
    elsif(AESL_clock'event and AESL_clock = '1') then
        if(done_cnt /= AUTOTB_TRANSACTION_NUM) then
            if(AESL_done = '1') then
                done_cnt <= done_cnt + 1;
            end if;
        end if;
    end if;
end process;

generate_sim_done_proc    :   process
    file      fp1         :   TEXT;
    file      fp2         :   TEXT;
    variable  fstatus1    :   FILE_OPEN_STATUS;
    variable  fstatus2    :   FILE_OPEN_STATUS;
begin
    while(done_cnt /= AUTOTB_TRANSACTION_NUM) loop
        wait until AESL_clock'event and AESL_clock = '1';
    end loop;
        wait until AESL_clock'event and AESL_clock = '1';
        wait until AESL_clock'event and AESL_clock = '1';
        wait until AESL_clock'event and AESL_clock = '1';
    file_open(fstatus1, fp1, "./rtl.infer_only.autotvout_judge.dat", READ_MODE);
    file_open(fstatus2, fp2, "./impl_rtl.infer_only.autotvout_judge.dat", READ_MODE);
    if(fstatus1 /= OPEN_OK) then
        assert false report string'("Open file rtl.infer_only.autotvout_judge.dat failed!!!") severity note;
    elsif(fstatus2 /= OPEN_OK) then
        assert false report string'("Open file impl_rtl.infer_only.autotvout_judge.dat failed!!!") severity note;
    else
        report string'("Comparing rtl.infer_only.autotvout_judge.dat with impl_rtl.infer_only.autotvout_judge.dat");
        post_check(fp1, fp2);
    end if;
    file_close(fp1);
    file_close(fp2);
    report "Simulation Passed.";
    assert false report "simulation done!" severity note;
    assert false report "NORMAL EXIT (note: failure is to force the simulator to stop)" severity failure;
    wait;
end process;

gen_clock_proc :   process
begin
    AESL_clock <= '0';
    while(true) loop
        wait for AUTOTB_CLOCK_PERIOD_DIV2;
        AESL_clock <= not AESL_clock;
    end loop;
    wait;
end process;

gen_reset_proc : process
    variable  rand            :   T_RANDINT     := init_rand(0);
    variable  rint            :   INTEGER;
begin
    rst <= '1';
    wait for 100 ns;
    for i in 1 to 3 loop
        wait until AESL_clock'event and AESL_clock = '1';
    end loop;
    rst <= '0';
    wait;
end process;

gen_start_proc : process
    variable  rand            :   T_RANDINT     := init_rand(0);
    variable  rint            :   INTEGER;
begin
  start <= '0';
  ce <= '1';
    wait until AESL_reset = '0';
  wait until (AESL_clock'event and AESL_clock = '1');
  start <= '1';
  while(ready_cnt /= AUTOTB_TRANSACTION_NUM + 1) loop
      wait until (AESL_clock'event and AESL_clock = '1');
      if(AESL_ready = '1') then
          start <= '0';
          start <= '1';
      end if;
  end loop;
  start <= '0';
  wait;
end process;


gen_continue_proc : process(AESL_done)
begin
    continue <= AESL_done;
end process;

gen_AESL_ready_delay_proc : process(AESL_clock)
begin
  if (AESL_clock'event and AESL_clock = '1') then
    if(AESL_reset = '1') then
          AESL_ready_delay <= '0';
      else
          AESL_ready_delay <= AESL_ready;
      end if;
  end if;
end process;

gen_ready_initial_proc : process
begin
    ready_initial <= '0';
    wait until AESL_start = '1';
    ready_initial <= '1';
    wait until AESL_clock'event and AESL_clock = '1';
    ready_initial <= '0';
    wait;
end process;

ready_last_n_proc : process
begin
  ready_last_n <= '1';
  while(ready_cnt /= AUTOTB_TRANSACTION_NUM) loop
    wait until AESL_clock'event and AESL_clock = '1';
  end loop;
  ready_last_n <= '0';
  wait;
end process;

gen_ready_delay_n_last_proc : process(AESL_clock)
begin
  if (AESL_clock'event and AESL_clock = '1') then
    if(AESL_reset = '1') then
          ready_delay_last_n <= '0';
      else
          ready_delay_last_n <= ready_last_n;
      end if;
  end if;
end process;

ready <= (ready_initial or AESL_ready_delay);
ready_wire <= ready_initial or AESL_ready_delay;
done_delay_last_n <= '0' when done_cnt = AUTOTB_TRANSACTION_NUM else '1';

gen_done_delay_proc : process(AESL_clock)
begin
  if (AESL_clock'event and AESL_clock = '1') then
    if(AESL_reset = '1') then
          AESL_done_delay <= '0';
          AESL_done_delay2 <= '0';
      else
          AESL_done_delay <= AESL_done and done_delay_last_n;
          AESL_done_delay2 <= AESL_done_delay;
      end if;
  end if;
end process;

gen_interface_done : process(ready, AESL_ready_delay, AESL_done_delay)
begin
    if(ready_cnt > 0 and ready_cnt < AUTOTB_TRANSACTION_NUM) then
        interface_done <= AESL_ready_delay;
    elsif(ready_cnt = AUTOTB_TRANSACTION_NUM) then
        interface_done <= AESL_done_delay;
    else
        interface_done <= '0';
    end if;
end process;

gen_clock_counter_proc : process(AESL_clock)
begin
  if (AESL_clock'event and AESL_clock = '0') then
    if(AESL_reset = '1') then
        AESL_clk_counter := 0;
    else
        AESL_clk_counter := AESL_clk_counter + 1;
    end if;
  end if;
end process;

gen_mLatcnterout_proc : process(AESL_clock)
begin
  if (AESL_clock'event and AESL_clock = '1') then
    if(AESL_reset = '1') then
          AESL_mLatCnterOut_addr := 0;
          AESL_mLatCnterOut(AESL_mLatCnterOut_addr) := AESL_clk_counter + 1 ;
          reported_stuck_cnt := 0;
      else
          if (AESL_done = '1' and AESL_mLatCnterOut_addr < AUTOTB_TRANSACTION_NUM + 1) then
              AESL_mLatCnterOut(AESL_mLatCnterOut_addr) := AESL_clk_counter;
              AESL_mLatCnterOut_addr := AESL_mLatCnterOut_addr + 1;
              reported_stuck <= '0';
          elsif (reported_stuck = '0' and reported_stuck_cnt < 4) then
              if ( AESL_mLatCnterIn_addr > AESL_mLatCnterOut_addr ) then
                  if ( AESL_clk_counter - AESL_mLatCnterIn(AESL_mLatCnterOut_addr) > 10000 and AESL_clk_counter - AESL_mLatCnterIn(AESL_mLatCnterOut_addr) > 10 * 3330487 ) then
                      report "WARNING: The latency is much larger than expected. Simulation may stuck.";
                      reported_stuck <= '1';
                      reported_stuck_cnt := reported_stuck_cnt + 1;
                  end if;
              end if;
          end if;
      end if;
  end if;
end process;

gen_mLatcnterin_proc : process(AESL_clock)
begin
  if (AESL_clock'event and AESL_clock = '1') then
    if(AESL_reset = '1') then
          AESL_mLatCnterIn_addr := 0;
      else
    if (AESL_start = '1' and AESL_mLatCnterIn_addr = 0) then
        AESL_mLatCnterIn(AESL_mLatCnterIn_addr) := AESL_clk_counter;
        AESL_mLatCnterIn_addr := AESL_mLatCnterIn_addr + 1;
    elsif (AESL_ready = '1' and AESL_mLatCnterIn_addr < AUTOTB_TRANSACTION_NUM + 1 ) then
        AESL_mLatCnterIn(AESL_mLatCnterIn_addr) := AESL_clk_counter;
        AESL_mLatCnterIn_addr := AESL_mLatCnterIn_addr + 1;
    end if;
      end if;
  end if;
end process;

gen_performance_check_proc : process
    variable transaction_counter : INTEGER;
    variable i : INTEGER;
    file     fp :   TEXT;
    variable    fstatus         :   FILE_OPEN_STATUS;
    variable    token_line      :   LINE;
    variable    token           :   STRING(1 to 1024);

    variable latthistime : INTEGER;
    variable lattotal : INTEGER;
    variable latmax : INTEGER;
    variable latmin : INTEGER;


    variable thrthistime : INTEGER;
    variable thrtotal : INTEGER;
    variable thrmax : INTEGER;
    variable thrmin : INTEGER;

    variable lataver : INTEGER;
    variable thraver : INTEGER;
    type latency_record is array(0 to AUTOTB_TRANSACTION_NUM + 1) of INTEGER;
    variable lat_array : latency_record;
    variable thr_array : latency_record;

begin
    i := 0;
    lattotal  := 0;
    latmax    := 0;
    latmin    := 16#7fffffff#;
    lataver   := 0;

    thrtotal  := 0;
    thrmax    := 0;
    thrmin    := 16#7fffffff#;
    thraver   := 0;

    wait until (AESL_clock'event and AESL_clock = '1');
    wait until (AESL_reset = '0'); 
    while (done_cnt /= AUTOTB_TRANSACTION_NUM) loop
        wait until (AESL_clock'event and AESL_clock = '1');
    end loop;
  wait for 0.001 ns;

    for i in 0 to AUTOTB_TRANSACTION_NUM - 1 loop
        latthistime := AESL_mLatCnterOut(i) - AESL_mLatCnterIn(i);
        lat_array(i) := latthistime;
        if (latthistime > latmax) then
            latmax := latthistime; 
        end if;
        if (latthistime < latmin) then
            latmin := latthistime;
        end if;
		lattotal := lattotal + latthistime;
		if (AUTOTB_TRANSACTION_NUM = 1) then
			thrthistime := latthistime;
		else
			thrthistime := AESL_mLatCnterIn(i + 1) - AESL_mLatCnterIn(i);
		end if;
     thr_array(i) := thrthistime;
		if (thrthistime > thrmax) then
		    thrmax := thrthistime;
      end if;
		if (thrthistime < thrmin) then
	        thrmin := thrthistime;
      end if;
		thrtotal := thrtotal + thrthistime;
	end loop;
	lataver := lattotal / AUTOTB_TRANSACTION_NUM;
	thraver := thrtotal / AUTOTB_TRANSACTION_NUM;

    file_open(fstatus, fp, AUTOTB_LAT_RESULT_FILE, WRITE_MODE);
    if (fstatus /= OPEN_OK) then
        assert false report "Open file " & AUTOTB_LAT_RESULT_FILE & " failed!!!" severity note;
        assert false report "ERROR: Simulation using HLS TB failed." severity failure;
    end if;

    if (AUTOTB_TRANSACTION_NUM = 1) then
        thrmax  := 0;
        thrmin  := 0;
        thraver := 0;
        write(token_line, "$MAX_LATENCY = " & '"' & integer'image(latmax) & '"');
        writeline(fp, token_line);
        write(token_line, "$MIN_LATENCY = " & '"' & integer'image(latmin) & '"');
        writeline(fp, token_line);
        write(token_line, "$AVER_LATENCY = " & '"' & integer'image(lataver) & '"');
        writeline(fp, token_line);
        write(token_line, "$MAX_THROUGHPUT = " & '"' & integer'image(thrmax) & '"');
        writeline(fp, token_line);
        write(token_line, "$MIN_THROUGHPUT = " & '"' & integer'image(thrmin) & '"');
        writeline(fp, token_line);
        write(token_line, "$AVER_THROUGHPUT = " & '"' & integer'image(thraver) & '"');
        writeline(fp, token_line);
    else
        write(token_line, "$MAX_LATENCY = " & '"' & integer'image(latmax) & '"');
        writeline(fp, token_line);
        write(token_line, "$MIN_LATENCY = " & '"' & integer'image(latmin) & '"');
        writeline(fp, token_line);
        write(token_line, "$AVER_LATENCY = " & '"' & integer'image(lataver) & '"');
        writeline(fp, token_line);
        write(token_line, "$MAX_THROUGHPUT = " & '"' & integer'image(thrmax) & '"');
        writeline(fp, token_line);
        write(token_line, "$MIN_THROUGHPUT = " & '"' & integer'image(thrmin) & '"');
        writeline(fp, token_line);
        write(token_line, "$AVER_THROUGHPUT = " & '"' & integer'image(thraver) & '"');
        writeline(fp, token_line);
    end if;

    file_close(fp);

    file_open(fstatus, fp, AUTOTB_PER_RESULT_TRANS_FILE, WRITE_MODE);
    if(fstatus /= OPEN_OK) then
        assert false report "Open file " & AUTOTB_PER_RESULT_TRANS_FILE & " failed!!!" severity note;
        assert false report "ERROR: Simulation using HLS TB failed." severity failure;
    end if;

    write(token_line,string'("                            latency            interval"));
    writeline(fp, token_line);
    if (AUTOTB_TRANSACTION_NUM = 1) then
        i := 0;
        thr_array(i) := 0;
        write(token_line,"transaction        " & integer'image(i) & "            " & integer'image(lat_array(i) ) & "            " & integer'image(thr_array(i) ) );
        writeline(fp, token_line);
    else
        for i in 0 to AESL_mLatCnterOut_addr - 1 loop
            write(token_line,"transaction        " & integer'image(i) & "            " & integer'image(lat_array(i) ) & "            " & integer'image(thr_array(i) ) );
            writeline(fp, token_line);
        end loop;
    end if;
    file_close(fp);
    wait;
end process;

end behav;
